import gql from "graphql-tag";

export const countMonitoraggioSpecies = gql`
    query CountMonitoraggioSpecies {
        countMonitoraggioSpecies
    }
`;

export const monitoraggioSpeciesQuery = gql`
    query MonitoraggioSpeciesQuery($pagination: PaginationInput, $orderBy: OrderByInput, $filtro: String) {

        countMonitoraggioSpecies2(filtro: $filtro)
        monitoraggioSpecies2(pagination: $pagination, orderBy: $orderBy, filtro: $filtro) {
            id
            idScheda
            dataCreazione
	    inizioRilievo
            validato
            utenteCreazione {
                id
		cognome
		nome
            }
            sitoNatura2000 {
                id
                nome
            }
            specie {
                id
                specie
                denominazioneTaxon
            }
            dataCreazione
            dataModifica
            rilevatori
	    transetto
        }
    }
`;


export const countInterventi = gql`
    query CountInterventi {
        countInterventi
    }
`;

export const interventiQuery = gql`
query interventiQuery($pagination: PaginationInput, $orderBy: OrderByInput, $filtro: String) {

    countInterventi(filtro: $filtro)
    interventi(pagination: $pagination, orderBy: $orderBy, filtro: $filtro) {
        id
        idScheda
        dataCreazione
        validato
        utenteCreazione {
            id
    cognome
    nome
        }
        sitoNatura2000 {
            id
            nome
        }
        specie {
            id
            specie
            denominazioneTaxon
        }
        dataModifica
        rilevatori
        transetto
        tipo
        info
    }
}
`;

export const interventoQuery = gql`
    query InterventoQuery($id: Long) {
        intervento(id: $id) {
            id
            idScheda
            dataIntervento
            transetto
            utenteCreazione {
                id
            }
            note
            tipo
            sottotipo
            info
            validato
            sitoNatura2000 {
                id
                nome
                tipo
            }
            specie {
                id
                specie
                denominazioneCompletaTaxon
                denominazioneTaxon
		        nomeMenu
		        nomeItaliano
            }
            
	    documenti {
                id
                uuid
                nomeFile
                dataModifica
                dataCreazione
                utenteModifica {
                    id
                    nome
                    cognome
                }
            }
        
            dataCreazione
            dataModifica
            rilevatori
        }

        specieProgettos {
            id
            acquatica
            specie {
                id
                nomeItaliano
            }
        }
    }
`;

export const monitoraggioSpecieQuery = gql`
    query MonitoraggioSpecieQuery($id: Long) {
        monitoraggioSpecie(id: $id) {
            id
            idScheda
            dataCreazione
            inizioRilievo
            fineRilievo
            transetto
            utenteCreazione {
                id
            }
            meteoInizio {
                id
                etichetta
            }
            meteoFine {
                id
                etichetta
            }
            temperaturaAria
            umiditaRelativa
            profonditaMaxAcqua
            profonditaMinAcqua
            pH
            conducibilita
            limpidezza {
                etichetta
            }
            visibilitaAcqua
            temperaturaAcquaFineTransetto
            temperaturaAcquaInizioTransetto
            vento
            note
            tipologiaMonitoraggio {
                id
                etichetta
            }
            validato
            sitoNatura2000 {
                id
                nome
                tipo
            }
            specie {
                id
                specie
                denominazioneCompletaTaxon
                denominazioneTaxon
		nomeMenu
		nomeItaliano
            }
            documenti {
                id
                uuid
                nomeFile
                dataModifica
                dataCreazione
                utenteModifica {
                    id
                    nome
                    cognome
                }
            }
            segnalazioni {
                id
		coordinataX
		coordinataY
                esemplariF
                esemplariM
                esemplariMF
		idHabitat
                stadioSviluppo {
                    id
                    etichetta
                }
		tipoMarcatura {
		    id
		    etichetta
		}
		idMarcatura
		tipoRicattura {
		    id
		    etichetta
		}
		idRicattura
                note
            }
            segnalazioniAltreSpecie {
                id
                specie {
                    id
                    nomeItaliano
		    nomeMenu
		    denominazioneTaxon
                }
                esemplariF
                esemplariM
                esemplariMF
                note
            }
            dataCreazione
            dataModifica
            rilevatori
        }

        specieProgettos {
            id
            acquatica
            specie {
                id
                nomeItaliano
            }
        }
    }
`;

export const speciesProgettoQuery = gql`
    query SpecisProgettoQuery {
        specieProgettos {
            id
            specie {
                id
                specie
                denominazioneTaxon
                classe
                famiglia
                denominazioneCompletaTaxon
                denominazioneTaxonBuono
            }
            acquatica
            icona
        }
    }
`;

export const authUserQuery = gql`
    query AuthUserQuery {
        utenteSessione {
            id
            nome
            cognome
            email
            ruolo {
                id
                nomeEsteso
                permessi {
                    id
                }
            }
            scadenzaAccount
            ultimoLogin
        }
    }
`;

export const sitoNatura2000SmartFilterQuery = gql`
    query SitoNatura2000SmartFilterQuery($testo: String) {
        sitoNatura2000SmartFilter(testo: $testo) {
            id
            nome
            tipo
        }
    }
`;

export const specieSmartFilterQuery = gql`
    query specieSmartFilterQuery($testo: String) {
        specieSmartFilter(testo: $testo) {
            id
            specie
            denominazioneTaxon
            classe
            famiglia
            denominazioneCompletaTaxon
            denominazioneTaxonBuono
	    nomeMenu
        }
    }
`;

export const condizioniMeteosQuery = gql`
    query CondizioniMeteoQuery {
        condizioniMeteos {
            id
            etichetta
        }
    }
`;

export const tipologiaMonitoraggiosQuery = gql`
    query TipologiaMonitoraggioQuery {
        tipologiaMonitoraggios {
            id
            etichetta
        }
    }
`;

export const limpidezzasQuery = gql`
    query LimpidezzasQuery {
        limpidezzas {
            id
            etichetta
        }
    }
`;

export const stadioSviluppoQuery = gql`
    query stadioSviluppoQuery {
        stadioSviluppos {
            id
            etichetta
        }
    }
`;

export const marcaturaQuery = gql`
    query marcaturaQuery {
        tipoMarcaturas {
            id
            etichetta
        }
    }
`;

export const monitoraggioHabitatsQuery = gql`
    query MonitoraggioHabitatsQuery($pagination: PaginationInput, $orderBy: OrderByInput, $filtro: String) {
        
        countMonitoraggioHabitat2(filtro: $filtro)
        monitoraggioHabitat2(pagination: $pagination, orderBy: $orderBy, filtro: $filtro) {
            id
            idScheda
            dataCreazione
            validato
            utenteCreazione {
                id
            }
            sitoNatura2000 {
                id
                nome
                tipo
            }
            specie {
                id
                specie
                denominazioneCompletaTaxon
                denominazioneTaxon
            }
            dataCreazione
            dataModifica
	    inizioRilievo
            rilevatori
	    transetto
        }
    }
`;

export const monitoraggioHabitatQuery = gql`
    query MonitoraggioHabitatQuery($id: Long) {

        monitoraggioHabitat(id: $id) {
            id
            idScheda
            dataCreazione
            validato
            inizioRilievo
            fineRilievo
            note
            transetto
            lunghezzaTransetto
            documenti {
                id
                nomeFile
		uuid
            }
            provincia
            comune
            localita
            metadati {
                id
                metadato {
                    id
                    descrizione
                }
                valore
            }
            tipologiaMonitoraggio {
                id
                etichetta
            }
            sitoNatura2000 {
                id
                nome
                tipo
            }
            specie {
                id
                specie
                denominazioneCompletaTaxon
                denominazioneTaxon
            }
            dataCreazione
            dataModifica
            rilevatori
		coordinataX
		coordinataY
        }

        specieProgettos {
            id
            acquatica
            specie {
                id
                nomeItaliano
            }
        }
    }
`

export const metadatiHabitatQuery = gql`
    query metadatiSpecie($id: Long){
	metadatiHabitatSpecie(id: $id) {
        id
        descrizione
    }
}
`


export const documentsQuery = gql`
    query DocumentsQuery($pagination: PaginationInput, $orderBy: OrderByInput, $filtri: String) {

        countDocumentos2(filtro: $filtri)
        documentos2(pagination: $pagination, orderBy: $orderBy, filtro: $filtri) {
            id
            uuid
            nomeFile
            descrizione
            formato
	    inElenco
            entita
            idEntita
        }
    }
`;


export const usersQuery = gql`
    query UsersQuery($pagination: PaginationInput, $orderBy: OrderByInput, $filtri: String) {

        countUtentes2(filtro: $filtri)
        utentes2(pagination: $pagination, orderBy: $orderBy, filtro: $filtri) {
            id
            nome
            cognome
            email
            scadenzaAccount
            ruolo {
                id
                nomeEsteso
            }
        }
    }
`;

export const userQuery = gql`
    query UserQuery($id: String) {
        utente(id: $id){
            id
            nome
            cognome
            email
            scadenzaAccount
            ruolo {
                id
                nomeEsteso
                permessi {
                    id
                    descrizione
                }
            }
        }
    }
`

export const rolesQuery = gql`
    query ruolosQuery{
        ruolos {
            id
            nomeEsteso
            permessi {
                id
                descrizione
            }
        }
    }
`

export const documentoQuery = gql`
    query DocumentQuery($id: Long) {
        documento(id: $id){
            id
            uuid
            nomeFile
            inElenco
            descrizione
            entita
            idEntita
            formato
        }
    }
`

